**************************************************************************************************
*******************LOCAL INCOME INEQUALITY AND HOUSEHOLD INDEBTEDNESS ****************************
*************************REGRESSION ANALYSIS *****************************************************
*************************DATE: JAN 2022 **********************************************************
*************************AUTHOR: KIM NGUYEN ******************************************************
**************************************************************************************************

clear all
set more off
set maxvar 30000
set matsize 10000

//Load data
use "UnbalancedHH_analytical.dta", clear

// Extensive margin

foreach x in debt mortgagedebt homedebt opropdebt nmdebt ccdebt hiredebt cardebt busdebt invdebt{
g have`x'debt = (`x'>0)
}

*Total debt
eststo m1: quietly xtreg havedebt dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Mortgage debt
eststo m2: quietly xtreg havemortgagedebt dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Home debt
eststo m3: quietly xtreg havehomedebt dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Other property debt
eststo m4: quietly xtreg haveopropdebt dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Non-ortgage debt
eststo m5: quietly xtreg havenmdebt dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Credit card debt
eststo m6: quietly xtreg haveccdebt dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Hire-purchase debt
eststo m7: quietly xtreg havehiredebt dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Car debt
eststo m8: quietly xtreg havecardebt dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Business debt
eststo m9: quietly xtreg havebusdebt dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Investment debt
eststo m10: quietly xtreg haveinvdebt dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)

*save table
esttab m1 m2 m3 m4 m5 m6 m7 m8 m9 m10 using "Tables\Table Appendix - Effects of Change in Gini - Extensive Margin.csv",  b(2) se(2) keep(*dgini*) margin title(Debt regressions) star(* 0.10 ** 0.05 *** 0.01) replace nogaps
